// Generated by CoffeeScript 2.7.0
(function() {
  var callWithJQuery,
    boundMethodCheck = function(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new Error('Bound instance method accessed before binding'); } },
    indexOf = [].indexOf,
    hasProp = {}.hasOwnProperty;

  callWithJQuery = function(pivotModule) {
    if (typeof exports === "object" && typeof module === "object") { // CommonJS
      return pivotModule(require("jquery"));
    } else if (typeof define === "function" && define.amd) { // AMD
      return define(["jquery"], pivotModule);
    } else {
      // Plain browser env
      return pivotModule(jQuery);
    }
  };

  callWithJQuery(function($) {
    var SubtotalPivotData, SubtotalRenderer, aggregatorTemplates, subtotalAggregatorTemplates, usFmtPct;
    SubtotalPivotData = (function() {
      var buildRowAttrsIndex, convertAttrsToGroups, processKey;

      class SubtotalPivotData extends $.pivotUtilities.PivotData {
        constructor(input, opts) {
          super(input, opts);
          this.sortKeys = this.sortKeys.bind(this);
          this.rowAttrsSortPredicate = this.rowAttrsSortPredicate.bind(this);
          this.groupPredicate = this.groupPredicate.bind(this);
          this.rowAxisPredicate = this.rowAxisPredicate.bind(this);
          this.valuePredicate = this.valuePredicate.bind(this);
          this.defaultPredicate = this.defaultPredicate.bind(this);
          this.multiplePredicatesSort = this.multiplePredicatesSort.bind(this);
          this.rowAttrGroups = convertAttrsToGroups(this.rowAttrs, opts.rendererOptions.rowSubtotalDisplay.splitPositions);
          this.rowAttrIndex = buildRowAttrsIndex(this.rowAttrGroups);
          this.callbacks = opts.callbacks;
        }

        processRecord(record) { //this code is called in a tight loop
          var colKey, fColKey, fRowKey, flatColKey, flatRowKey, i, j, k, m, n, ref, results, rowKey;
          rowKey = [];
          colKey = [];
          this.allTotal.push(record);
          rowKey = processKey(this.callbacks, record, this.rowTotals, this.rowKeys, this.rowAttrs, (key) => {
            return this.aggregator(this, key, []);
          });
          colKey = processKey(this.callbacks, record, this.colTotals, this.colKeys, this.colAttrs, (key) => {
            return this.aggregator(this, [], key);
          });
          m = rowKey.length - 1;
          n = colKey.length - 1;
          if (m < 0 || n < 0) {
            return;
          }
          results = [];
          for (i = k = 0, ref = m; (0 <= ref ? k <= ref : k >= ref); i = 0 <= ref ? ++k : --k) {
            fRowKey = rowKey.slice(0, i + 1);
            flatRowKey = (this.callbacks ? this.callbacks.formatArray(this.rowAttrs, fRowKey) : fRowKey).join(String.fromCharCode(0));
            if (!this.tree[flatRowKey]) {
              this.tree[flatRowKey] = {};
            }
            results.push((function() {
              var l, ref1, results1;
              results1 = [];
              for (j = l = 0, ref1 = n; (0 <= ref1 ? l <= ref1 : l >= ref1); j = 0 <= ref1 ? ++l : --l) {
                fColKey = colKey.slice(0, j + 1);
                flatColKey = (this.callbacks ? this.callbacks.formatArray(this.colAttrs, fColKey) : fColKey).join(String.fromCharCode(0));
                if (!this.tree[flatRowKey][flatColKey]) {
                  this.tree[flatRowKey][flatColKey] = this.aggregator(this, fRowKey, fColKey);
                }
                results1.push(this.tree[flatRowKey][flatColKey].push(record));
              }
              return results1;
            }).call(this));
          }
          return results;
        }

        sortKeys() {
          var v;
          boundMethodCheck(this, SubtotalPivotData);
          if (!this.sorted) {
            this.sorted = true;
            this.rowKeys.sort(this.rowAttrsSortPredicate());
            v = (r, c) => {
              return this.getAggregator(r, c).value();
            };
            switch (this.colOrder) {
              case "value_a_to_z":
                return this.colKeys.sort((a, b) => {
                  return $.pivotUtilities.naturalSort(v([], a), v([], b));
                });
              case "value_z_to_a":
                return this.colKeys.sort((a, b) => {
                  return -$.pivotUtilities.naturalSort(v([], a), v([], b));
                });
              default:
                return this.colKeys.sort(this.arrSort(this.colAttrs, this.callbacks));
            }
          }
        }

        rowAttrsSortPredicate() {
          var group, groupPredicates;
          boundMethodCheck(this, SubtotalPivotData);
          groupPredicates = (function() {
            var k, len1, ref, results;
            ref = this.rowAttrGroups;
            results = [];
            for (k = 0, len1 = ref.length; k < len1; k++) {
              group = ref[k];
              results.push(this.groupPredicate(group));
            }
            return results;
          }).call(this);
          return this.multiplePredicatesSort(groupPredicates, this.callbacks);
        }

        groupPredicate(attrGroup) {
          var k, lastKeyIndex, len1, predicates, ref, ref1, sortItem;
          boundMethodCheck(this, SubtotalPivotData);
          predicates = [];
          ref = this.sortItems;
          for (k = 0, len1 = ref.length; k < len1; k++) {
            sortItem = ref[k];
            if (typeof sortItem.value === 'string') {
              if (ref1 = sortItem.value, indexOf.call(attrGroup, ref1) >= 0) {
                predicates.push(this.rowAxisPredicate(sortItem));
              }
            } else {
              lastKeyIndex = this.rowAttrIndex[attrGroup[attrGroup.length - 1]];
              predicates.push(this.valuePredicate(sortItem, lastKeyIndex));
            }
          }
          if (predicates.length === 0) {
            predicates.push(this.defaultPredicate(attrGroup, this.rowAttrIndex, this.callbacks));
          }
          return this.multiplePredicatesSort(predicates, this.callbacks);
        }

        rowAxisPredicate(sortItem) {
          var index;
          boundMethodCheck(this, SubtotalPivotData);
          index = this.rowAttrIndex[sortItem.value];
          return function(a, b) {
            if (sortItem.direction) {
              return $.pivotUtilities.naturalSort(a[index], b[index]);
            } else {
              return -$.pivotUtilities.naturalSort(a[index], b[index]);
            }
          };
        }

        valuePredicate(sortItem, lastKeyIndex) {
          var colKey, value;
          boundMethodCheck(this, SubtotalPivotData);
          value = (r, c) => {
            return this.getAggregator(r, c).value();
          };
          colKey = sortItem.value;
          return function(a, b) {
            if (sortItem.direction) {
              return $.pivotUtilities.naturalSort(value(a.slice(0, +lastKeyIndex + 1 || 9e9), colKey), value(b.slice(0, +lastKeyIndex + 1 || 9e9), colKey));
            } else {
              return -$.pivotUtilities.naturalSort(value(a.slice(0, +lastKeyIndex + 1 || 9e9), colKey), value(b.slice(0, +lastKeyIndex + 1 || 9e9), colKey));
            }
          };
        }

        defaultPredicate(attrGroup, rowAttrIndex, callbacks) {
          boundMethodCheck(this, SubtotalPivotData);
          return function(a, b) {
            var attr, i, k, len1, result;
            for (k = 0, len1 = attrGroup.length; k < len1; k++) {
              attr = attrGroup[k];
              i = rowAttrIndex[attr];
              result = $.pivotUtilities.naturalSort(a[i], b[i], attr, callbacks);
              if (result !== 0) {
                return result;
              }
            }
            return 0;
          };
        }

        multiplePredicatesSort(predicates, callbacks) {
          boundMethodCheck(this, SubtotalPivotData);
          return function(a, b) {
            var k, len1, predicate, result;
            for (k = 0, len1 = predicates.length; k < len1; k++) {
              predicate = predicates[k];
              result = predicate(a, b, callbacks);
              if (result !== 0) {
                return result;
              }
            }
            return 0;
          };
        }

      };

      processKey = function(callbacks, record, totals, keys, attrs, getAggregator) {
        var addKey, attr, flatKey, k, key, len1;
        key = [];
        addKey = false;
        for (k = 0, len1 = attrs.length; k < len1; k++) {
          attr = attrs[k];
          key.push(record[attr]);
          flatKey = (callbacks ? callbacks.formatArray(attrs, key) : key).join(String.fromCharCode(0));
          if (!totals[flatKey]) {
            totals[flatKey] = getAggregator(key.slice());
            addKey = true;
          }
          totals[flatKey].push(record);
        }
        if (addKey) {
          keys.push(key);
        }
        return key;
      };

      buildRowAttrsIndex = (attrGroups) => {
        var attr, attrGroup, i, index, k, l, len1, len2;
        i = 0;
        index = {};
        for (k = 0, len1 = attrGroups.length; k < len1; k++) {
          attrGroup = attrGroups[k];
          for (l = 0, len2 = attrGroup.length; l < len2; l++) {
            attr = attrGroup[l];
            index[attr] = i;
            ++i;
          }
        }
        return index;
      };

      convertAttrsToGroups = (attrs, splitPositions) => {
        var attrGroups, k, len1, pos, prev;
        attrGroups = [];
        prev = 0;
        for (k = 0, len1 = splitPositions.length; k < len1; k++) {
          pos = splitPositions[k];
          attrGroups.push(attrs.slice(prev, +pos + 1 || 9e9));
          prev = pos + 1;
        }
        return attrGroups;
      };

      return SubtotalPivotData;

    }).call(this);
    $.pivotUtilities.SubtotalPivotData = SubtotalPivotData;
    SubtotalRenderer = function(pivotData, opts, clusterize) {
      var addClass, adjustColAxisHeader, adjustRowAxisHeader, allTotal, arrowCollapsed, arrowColumnIsNeeded, arrowExpanded, arrowText, buildAxisHeaders, buildColAxisHeader, buildColHeader, buildColTotals, buildColTotalsHeader, buildGrandTotal, buildRowAxisHeader, buildRowHeader, buildRowHeaders, buildRowTotalsHeader, buildValues, callbacks, classColCollapsed, classColExpanded, classColHide, classColShow, classCollapsed, classExpanded, classRowCollapsed, classRowExpanded, classRowHide, classRowShow, classZoom, clickStatusCollapsed, clickStatusExpanded, colAttrs, colKeys, colSubtotalIsEnabled, colTotals, collapseChildCol, collapseChildRow, collapseCol, collapseColAxis, collapseColAxisHeaders, collapseHiddenColSubtotal, collapseRow, collapseRowAxis, collapseRowAxisHeaders, collapseShowColSubtotal, collapseShowRowSubtotal, createArrowAndTextDivs, createColAttrHeaderTH, createColAxisHeaderTH, createColGroup, createElement, createRowAttrHeaderTH, createRowAxisHeaderTH, createValueTD, defaults, emptyTopAttrTH, expandAxis, expandChildCol, expandChildRow, expandCol, expandHideColSubtotal, expandHideRowSubtotal, expandRow, expandShowColSubtotal, expandShowRowSubtotal, fillData, findAxisHeadersColCount, getColumnWidth, getTableEventHandlers, hasClass, hideChildCol, hideChildRow, hideColAxisHeadersColumn, hideColsTotalRow, hideRowsTotalsCol, i, longestGroupLength, main, processColKeys, processRowKeys, ref, ref1, ref2, removeClass, renderColAttrHeader, renderColAxisHeader, renderRowAttrHeader, renderRowAxisHeader, renderValueCell, replaceClass, rowArrowsLevelPadding, rowArrowsPadding, rowAttrs, rowGroups, rowHeaderColsData, rowKeys, rowSplitPositions, rowTotals, setAttributes, showChildCol, showChildRow, tree;
      defaults = {
        table: {
          clickCallback: null
        },
        localeStrings: {
          totals: "Totals",
          subtotalOf: "Subtotal of"
        },
        arrowCollapsed: "\u25B6",
        arrowExpanded: "\u25E2",
        rowSubtotalDisplay: {
          displayOnTop: true,
          collapseAt: 99999,
          hideOnExpand: false,
          disableExpandCollapse: false
        },
        colSubtotalDisplay: {
          displayOnTop: true,
          collapseAt: 99999,
          hideOnExpand: false,
          disableExpandCollapse: false
        }
      };
      opts = $.extend(true, {}, defaults, opts);
      if (typeof opts.rowSubtotalDisplay.collapseAt !== 'undefined' && opts.collapseRowsAt !== null) {
        opts.rowSubtotalDisplay.collapseAt = opts.collapseRowsAt;
      }
      if (opts.rowSubtotalDisplay.splitPositions == null) {
        opts.rowSubtotalDisplay.splitPositions = (function() {
          var k, ref, results;
          results = [];
          for (i = k = 0, ref = pivotData.rowAttrs.length; (0 <= ref ? k < ref : k > ref); i = 0 <= ref ? ++k : --k) {
            results.push(i);
          }
          return results;
        })();
      }
      if (typeof opts.colSubtotalDisplay.collapseAt !== 'undefined' && opts.collapseColsAt !== null) {
        opts.colSubtotalDisplay.collapseAt = opts.collapseColsAt;
      }
      if (opts.colSubtotalDisplay.splitPositions == null) {
        opts.colSubtotalDisplay.splitPositions = (function() {
          var k, ref, results;
          results = [];
          for (i = k = 0, ref = pivotData.colAttrs.length; (0 <= ref ? k < ref : k > ref); i = 0 <= ref ? ++k : --k) {
            results.push(i);
          }
          return results;
        })();
      }
      colAttrs = pivotData.colAttrs;
      rowAttrs = pivotData.rowAttrs;
      rowKeys = pivotData.getRowKeys();
      colKeys = pivotData.getColKeys();
      tree = pivotData.tree;
      callbacks = pivotData.callbacks;
      rowTotals = pivotData.rowTotals;
      colTotals = pivotData.colTotals;
      allTotal = pivotData.allTotal;
      classRowHide = "rowhide";
      classRowShow = "rowshow";
      classColHide = "colhide";
      classColShow = "colshow";
      clickStatusExpanded = "expanded";
      clickStatusCollapsed = "collapsed";
      classExpanded = "expanded";
      classCollapsed = "collapsed";
      classZoom = "zoom";
      classRowExpanded = "rowexpanded";
      classRowCollapsed = "rowcollapsed";
      classColExpanded = "colexpanded";
      classColCollapsed = "colcollapsed";
      arrowExpanded = opts.arrowExpanded;
      arrowCollapsed = opts.arrowCollapsed;
      rowSplitPositions = opts.rowSubtotalDisplay.splitPositions;
      rowGroups = pivotData.rowAttrGroups;
      rowArrowsPadding = 5;
      rowArrowsLevelPadding = 10;
      hideColAxisHeadersColumn = (ref = opts.hideColAxisHeadersColumn) != null ? ref : false;
      hideColsTotalRow = (ref1 = opts.hideColsTotalsRow) != null ? ref1 : false;
      hideRowsTotalsCol = (ref2 = opts.hideRowsTotalsCol) != null ? ref2 : false;
      emptyTopAttrTH = null;
      
      // Based on http://stackoverflow.com/questions/195951/change-an-elements-class-with-javascript -- Begin
      hasClass = function(element, className) {
        var regExp;
        regExp = new RegExp("(?:^|\\s)" + className + "(?!\\S)", "g");
        return element.className.match(regExp) !== null;
      };
      removeClass = function(element, className) {
        var k, len1, name, ref3, regExp, results;
        ref3 = className.split(" ");
        results = [];
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          name = ref3[k];
          regExp = new RegExp("(?:^|\\s)" + name + "(?!\\S)", "g");
          results.push(element.className = element.className.replace(regExp, ''));
        }
        return results;
      };
      addClass = function(element, className) {
        var k, len1, name, ref3, results;
        ref3 = className.split(" ");
        results = [];
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          name = ref3[k];
          if (!hasClass(element, name)) {
            results.push(element.className += " " + name);
          } else {
            results.push(void 0);
          }
        }
        return results;
      };
      replaceClass = function(element, replaceClassName, byClassName) {
        removeClass(element, replaceClassName);
        return addClass(element, byClassName);
      };
      // Based on http://stackoverflow.com/questions/195951/change-an-elements-class-with-javascript -- End 
      createElement = function(elementType, className, attributes, eventHandlers) {
        var attr, e, event, handler, val;
        e = document.createElement(elementType);
        if (className != null) {
          e.className = className;
        }
        if (attributes != null) {
          for (attr in attributes) {
            if (!hasProp.call(attributes, attr)) continue;
            val = attributes[attr];
            e.setAttribute(attr, val);
          }
        }
        if (eventHandlers != null) {
          for (event in eventHandlers) {
            if (!hasProp.call(eventHandlers, event)) continue;
            handler = eventHandlers[event];
            e.addEventListener(event, handler);
          }
        }
        return e;
      };
      createValueTD = function(value, rowKey, colKey, aggregator, className, attributes, eventHandlers) {
        var td;
        td = createElement("td", className, attributes, eventHandlers);
        td.onmousedown = function(event) {
          if (event.detail > 1) {
            if (callbacks != null) {
              return event.preventDefault();
            }
          }
        };
        td.ondblclick = function(event) {
          if (callbacks != null) {
            return callbacks.valueCellDblClickHandler(event, td, rowKey, colKey);
          }
        };
        renderValueCell(td, value, rowKey, colKey, aggregator);
        return td;
      };
      renderValueCell = function(td, value, rowKey, colKey, aggregator) {
        if (callbacks != null) {
          return callbacks.renderValueCell(td, value, rowKey, colKey);
        } else {
          return td.textContent = aggregator.format(value);
        }
      };
      createArrowAndTextDivs = function(th, arrowClass, textClass) {
        var arrowDiv, textDiv, wrapperDiv;
        wrapperDiv = createElement("div", "wrapperDiv fill-parent-perc");
        th.append(wrapperDiv);
        arrowDiv = createElement("div", arrowClass);
        wrapperDiv.appendChild(arrowDiv);
        th.arrowDiv = arrowDiv;
        textDiv = createElement("div", textClass);
        wrapperDiv.appendChild(textDiv);
        return th.textDiv = textDiv;
      };
      createColAxisHeaderTH = function(attr, className, textContent, isExpanded, attributes) {
        var textElement, th;
        th = createElement("th", className, attributes);
        textElement = th;
        if (isExpanded != null) {
          createArrowAndTextDivs(th, "axisHeaderArrowDiv", "axisHeaderTextDiv");
          textElement = th.textDiv;
        }
        textElement.onmousedown = function(event) {
          if (event.detail > 1) {
            if (callbacks != null) {
              return event.preventDefault();
            }
          }
        };
        textElement.ondblclick = function(event) {
          if (callbacks != null) {
            return callbacks.colAxisHeaderDblClickHandler(event, textElement, attr);
          }
        };
        renderColAxisHeader(th, textContent, attr, isExpanded, false);
        return th;
      };
      renderColAxisHeader = function(th, textContent, attr, isExpanded, arrowOnly) {
        if (isExpanded != null) {
          if (callbacks != null) {
            callbacks.renderAxisHeaderCell(th.arrowDiv, textContent, attr, isExpanded, true);
            if (!arrowOnly) {
              return callbacks.renderAxisHeaderCell(th.textDiv, textContent, attr, isExpanded, false);
            }
          } else {
            th.arrowDiv.textContent = arrowText(isExpanded);
            if (!arrowOnly) {
              return th.textDiv.textContent = textContent;
            }
          }
        } else if (callbacks != null) {
          return callbacks.renderAxisHeaderCell(th, textContent, attr, isExpanded, false);
        } else {
          return th.textContent = textContent;
        }
      };
      createRowAxisHeaderTH = function(attr, className, textContent, isArrow, isExpanded, attributes) {
        var th;
        th = createElement("th", className, attributes);
        if (!isArrow) {
          th.onmousedown = function(event) {
            if (event.detail > 1) {
              if (callbacks != null) {
                return event.preventDefault();
              }
            }
          };
          th.ondblclick = function(event) {
            if (callbacks != null) {
              return callbacks.rowAxisHeaderDblClickHandler(event, th, attr);
            }
          };
        }
        renderRowAxisHeader(th, textContent, attr, isArrow, isExpanded);
        return th;
      };
      renderRowAxisHeader = function(th, textContent, attr, isArrow, isExpanded) {
        if (callbacks != null) {
          return callbacks.renderAxisHeaderCell(th, textContent, attr, isExpanded, isArrow);
        } else {
          return th.textContent = isArrow ? arrowText(isExpanded) : textContent;
        }
      };
      createRowAttrHeaderTH = function(rowKey, cellAttr, className, value, isArrow, isExpanded, isLastChildList, attributes) {
        var th;
        th = createElement("th", className, attributes);
        if (!isArrow) {
          th.onmousedown = function(event) {
            if (event.detail > 1) {
              if (callbacks != null) {
                return event.preventDefault();
              }
            }
          };
          th.onclick = function(event) {
            if (callbacks != null) {
              return callbacks.rowAttrHeaderClickHandler(event, th, rowKey, cellAttr);
            }
          };
        }
        renderRowAttrHeader(th, value, rowKey, cellAttr, isArrow, isExpanded, isLastChildList);
        return th;
      };
      renderRowAttrHeader = function(th, value, rowKey, cellAttr, isArrow, isExpanded, isLastChildList) {
        if (callbacks != null) {
          return callbacks.renderRowAttrHeaderCell(th, value, rowKey, cellAttr, isExpanded, isArrow, isLastChildList);
        } else {
          return th.textContent = isArrow ? arrowText(isExpanded) : value;
        }
      };
      createColAttrHeaderTH = function(colKey, isSubtotal, className, value, isExpanded, colsData, attributes) {
        var textElement, th;
        th = createElement("th", className, attributes);
        textElement = th;
        if (isExpanded != null) {
          createArrowAndTextDivs(th, "colAttrHeaderArrowDiv", "colAttrHeaderTextDiv");
          textElement = th.textDiv;
        }
        textElement.onmousedown = function(event) {
          if (event.detail > 1) {
            if (callbacks != null) {
              return event.preventDefault();
            }
          }
        };
        textElement.onclick = function(event) {
          if (callbacks != null) {
            return callbacks.colAttrHeaderClickHandler(event, textElement, colKey, isSubtotal);
          }
        };
        if (colKey.length === colAttrs.length || isSubtotal || colKey.length === 0) {
          colsData.push({
            width: getColumnWidth(true, colKey, null, false),
            colnode: attributes["data-colnode"]
          });
        }
        renderColAttrHeader(th, value, colKey, isSubtotal, isExpanded, false);
        return th;
      };
      renderColAttrHeader = function(th, value, colKey, isSubtotal, isExpanded, arrowOnly) {
        if (isExpanded != null) {
          if (callbacks != null) {
            callbacks.renderColAttrHeaderCell(th.arrowDiv, value, colKey, isSubtotal, isExpanded, true);
            if (!arrowOnly) {
              return callbacks.renderColAttrHeaderCell(th.textDiv, value, colKey, isSubtotal, isExpanded, false);
            }
          } else {
            th.arrowDiv.textContent = arrowText(isExpanded);
            if (!arrowOnly) {
              if (!arrowOnly) {
                return th.textDiv.textContent = value;
              }
            }
          }
        } else if (callbacks != null) {
          return callbacks.renderColAttrHeaderCell(th, value, colKey, isSubtotal, isExpanded, false);
        } else {
          return th.textContent = value;
        }
      };
      arrowText = function(isExpanded) {
        if (isExpanded === true) {
          return ` ${arrowExpanded} `;
        } else if (isExpanded === false) {
          return ` ${arrowCollapsed} `;
        } else {
          return "";
        }
      };
      setAttributes = function(e, attrs) {
        var a, results, v;
        results = [];
        for (a in attrs) {
          if (!hasProp.call(attrs, a)) continue;
          v = attrs[a];
          results.push(e.setAttribute(a, v));
        }
        return results;
      };
      processColKeys = function(colAttrs, keysArr) {
        var headers, lastIdx, row;
        lastIdx = keysArr[0].length - 1;
        headers = {
          children: []
        };
        row = 0;
        keysArr.reduce((val0, k0) => {
          var col;
          col = 0;
          k0.reduce((acc, curVal, curIdx) => {
            var curValString, index, k, key, node, ref3;
            curValString = callbacks ? callbacks.formatValue(colAttrs[curIdx], curVal, false) : curVal;
            if (!acc[curValString]) {
              key = k0.slice(0, col + 1);
              acc[curValString] = {
                row: row,
                col: col,
                descendants: 0,
                children: [],
                value: curVal,
                key: key,
                flatKey: (callbacks ? callbacks.formatArray(colAttrs, key) : key).join(String.fromCharCode(0)),
                firstLeaf: null,
                leaves: 0,
                parent: col !== 0 ? acc : null,
                childrenSpan: 0
              };
              acc.children.push(curValString);
            }
            if (col > 0) {
              acc.descendants++;
            }
            col++;
            if (curIdx === lastIdx) {
              node = headers;
              for (i = k = 0, ref3 = lastIdx - 1; (0 <= ref3 ? k <= ref3 : k >= ref3); i = 0 <= ref3 ? ++k : --k) {
                if (!(lastIdx > 0)) {
                  continue;
                }
                index = callbacks ? callbacks.formatValue(colAttrs[i], k0[i]) : k0[i];
                node[index].leaves++;
                if (!node[index].firstLeaf) {
                  node[index].firstLeaf = acc[curValString];
                }
                node = node[index];
              }
              return headers;
            }
            return acc[curValString];
          }, headers);
          row++;
          return headers;
        }, headers);
        return headers;
      };
      processRowKeys = function(rowAttrs, keysArr, className, splitPositions) {
        var headers, lastIdx, row;
        lastIdx = keysArr[0].length - 1;
        headers = {
          children: []
        };
        row = 0;
        keysArr.reduce((val0, k0) => {
          var col, curColumns, curElement;
          col = 0;
          curElement = [];
          curColumns = [];
          k0.reduce((acc, curVal, curIdx) => {
            var flatCurElement, key, node;
            curElement.push(curVal);
            curColumns.push(rowAttrs[curIdx]);
            if (splitPositions.indexOf(curIdx) !== -1) {
              flatCurElement = (callbacks ? callbacks.formatArray(curColumns, curElement) : curElement).join(String.fromCharCode(0));
              if (!acc[flatCurElement]) {
                key = k0.slice(0, curIdx + 1);
                acc[flatCurElement] = {
                  row: row,
                  col: col,
                  descendants: 0,
                  children: [],
                  values: curElement,
                  text: flatCurElement,
                  key: key,
                  flatKey: (callbacks ? callbacks.formatArray(rowAttrs, key) : key).join(String.fromCharCode(0)),
                  firstLeaf: null,
                  leaves: 0,
                  parent: col !== 0 ? acc : null,
                  childrenSpan: 0
                };
                acc.children.push(flatCurElement);
              }
              if (col > 0) {
                acc.descendants++;
              }
              col++;
              if (curIdx === lastIdx) {
                node = acc;
                while (node != null) {
                  node.leaves++;
                  if (!node.firstLeaf) {
                    node.firstLeaf = acc[flatCurElement];
                  }
                  node = node.parent;
                }
                return headers;
              }
              curElement = [];
              curColumns = [];
              return acc[flatCurElement];
            } else {
              return acc;
            }
          }, headers);
          row++;
          return headers;
        }, headers);
        return headers;
      };
      buildColAxisHeader = function(axisHeaders, index, attrs, opts, disabledArrow) {
        var ah, hClass, isExpanded;
        ah = {
          text: attrs[index],
          expandedCount: 0,
          expandables: 0,
          attrHeaders: [],
          clickStatus: clickStatusExpanded,
          onClick: collapseColAxis
        };
        if (!disabledArrow) {
          isExpanded = true;
        }
        hClass = classExpanded;
        if (index >= opts.collapseAt) {
          isExpanded = false;
          hClass = classCollapsed;
          ah.clickStatus = clickStatusCollapsed;
          ah.onClick = expandAxis;
        }
        if (!hideColAxisHeadersColumn) {
          ah.th = createColAxisHeaderTH(ah.text, `pvtAxisLabel ${hClass}`, ah.text, isExpanded);
          if (!disabledArrow) {
            ah.th.arrowDiv.onclick = function(event) {
              event = event || window.event;
              return ah.onClick(axisHeaders, index, attrs, opts);
            };
          }
        }
        axisHeaders.ah.push(ah);
        return ah;
      };
      arrowColumnIsNeeded = function() {
        return rowGroups.length > 1;
      };
      buildRowAxisHeader = function(axisHeaders, index, attrs, opts, disabledArrow) {
        var ah, arrowTh, attr, flatText, hClass, isExpanded, k, len1, ref3, th, zoomClassPart;
        ah = {
          text: "",
          values: [],
          expandedCount: 0,
          expandables: 0,
          attrHeaders: [],
          clickStatus: clickStatusExpanded,
          onClick: collapseRowAxis,
          ths: []
        };
        if (!disabledArrow) {
          isExpanded = true;
        }
        hClass = classExpanded;
        if (index >= opts.collapseAt) {
          isExpanded = false;
          hClass = classCollapsed;
          ah.clickStatus = clickStatusCollapsed;
          ah.onClick = expandAxis;
        }
        ref3 = rowGroups[index];
        for (i = k = 0, len1 = ref3.length; k < len1; i = ++k) {
          attr = ref3[i];
          if (i === 0 && arrowColumnIsNeeded()) {
            zoomClassPart = isExpanded != null ? classZoom : "";
            arrowTh = createRowAxisHeaderTH(attr, `pvtAxisLabel ${hClass} ${zoomClassPart}`, "", true, isExpanded, {
              style: `padding-left: ${rowArrowsPadding + index * rowArrowsLevelPadding}px;`
            });
            ah.arrowTh = arrowTh;
            ah.ths.push(arrowTh);
          }
          th = createRowAxisHeaderTH(attr, `pvtAxisLabel ${hClass}`, attr, false);
          ah.ths.push(th);
          ah.values.push(attr);
        }
        flatText = rowGroups[index].join(String.fromCharCode(0));
        ah.text = flatText;
        if (!disabledArrow) {
          ah.arrowTh.onclick = function(event) {
            event = event || window.event;
            return ah.onClick(axisHeaders, index, attrs, opts);
          };
        }
        axisHeaders.ah.push(ah);
        return ah;
      };
      buildAxisHeaders = function(thead, rowAttrs, colAttrs, opts) {
        var ah, colAxisHeaders, curCol, curGroup, disabled, groupLen, k, l, len1, longestRowGroupLength, ref3, ref4, row, rowAxisHeaders, rowGroupsNumber, rowsNumber, th, tr, trs;
        colAxisHeaders = {
          collapseAttrHeader: collapseCol,
          expandAttrHeader: expandCol,
          ah: []
        };
        rowAxisHeaders = {
          collapseAttrHeader: collapseRow,
          expandAttrHeader: expandRow,
          ah: []
        };
        rowGroupsNumber = rowGroups.length;
        longestRowGroupLength = longestGroupLength(rowGroups);
        rowsNumber = Math.max(rowGroupsNumber, colAttrs.length);
        trs = [];
        for (row = k = 0, ref3 = rowsNumber; (0 <= ref3 ? k < ref3 : k > ref3); row = 0 <= ref3 ? ++k : --k) {
          tr = createElement("tr");
          trs.push(tr);
          thead.appendChild(tr);
          if (row + rowGroupsNumber >= rowsNumber) {
            curGroup = row - (rowsNumber - rowGroupsNumber);
            disabled = curGroup === rowGroupsNumber - 1;
            ah = buildRowAxisHeader(rowAxisHeaders, curGroup, rowAttrs, opts.rowSubtotalDisplay, disabled);
            ref4 = ah.ths;
            for (l = 0, len1 = ref4.length; l < len1; l++) {
              th = ref4[l];
              tr.appendChild(th);
            }
            ah.tr = tr;
            groupLen = rowGroups[curGroup].length;
            if (groupLen < longestRowGroupLength) {
              tr.appendChild(createElement("th", "pvtEmptyHeader", {
                colspan: longestRowGroupLength - groupLen
              }));
            }
          } else if (row === 0 && longestRowGroupLength > 0) {
            tr.appendChild(createElement("th", "pvtEmptyHeader", {
              colspan: longestRowGroupLength + (arrowColumnIsNeeded() ? 1 : 0),
              rowspan: rowsNumber - rowGroupsNumber
            }));
          }
          if (row + colAttrs.length >= rowsNumber) {
            curCol = row - (rowsNumber - colAttrs.length);
            disabled = !colSubtotalIsEnabled(opts.colSubtotalDisplay, curCol);
            ah = buildColAxisHeader(colAxisHeaders, curCol, colAttrs, opts.colSubtotalDisplay, disabled);
            if (!hideColAxisHeadersColumn) {
              tr.appendChild(ah.th);
            }
            ah.tr = tr;
          } else if (row === 0 && colAttrs.length > 0 && !hideColAxisHeadersColumn) {
            tr.appendChild(createElement("th", "pvtEmptyHeader", {
              rowspan: rowsNumber - colAttrs.length
            }));
          }
        }
        return [colAxisHeaders, rowAxisHeaders, trs];
      };
      longestGroupLength = function(splitGroups) {
        var group, k, len, len1;
        len = 0;
        for (k = 0, len1 = splitGroups.length; k < len1; k++) {
          group = splitGroups[k];
          len = Math.max(len, group.length);
        }
        return len;
      };
      colSubtotalIsEnabled = function(subtotalOpts, index) {
        var splitPositions;
        splitPositions = subtotalOpts.splitPositions;
        if (index === splitPositions[splitPositions.length - 1] || subtotalOpts.disableExpandCollapse || subtotalOpts.disableSubtotal) {
          return false;
        }
        return splitPositions.indexOf(index) !== -1;
      };
      buildColHeader = function(callbacks, axisHeaders, attrHeaders, h, rowAttrs, colAttrs, node, opts, colsData) {
        var ah, chKey, isExpanded, k, len1, ref3, ref4;
        ref3 = h.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          // DF Recurse
          buildColHeader(callbacks, axisHeaders, attrHeaders, h[chKey], rowAttrs, colAttrs, node, opts, colsData);
        }
        // Process
        ah = axisHeaders.ah[h.col];
        ah.attrHeaders.push(h);
        h.node = node.counter;
        h.onClick = collapseCol;
        if (colSubtotalIsEnabled(opts.colSubtotalDisplay, h.col) && h.children.length !== 0) {
          isExpanded = true;
        }
        h.th = createColAttrHeaderTH(h.key, false, `pvtColLabel ${classColShow} col${h.row} colcol${h.col} ${classColExpanded}`, h.value, isExpanded, colsData, {
          "data-colnode": h.node,
          "colspan": h.children.length !== 0 ? h.childrenSpan : void 0
        });
        if (h.children.length !== 0 && colSubtotalIsEnabled(opts.colSubtotalDisplay, h.col)) {
          ah.expandables++;
          ah.expandedCount += 1;
          if (!opts.colSubtotalDisplay.hideOnExpand) {
            h.th.colSpan++;
          }
          if (!opts.colSubtotalDisplay.disableExpandCollapse) {
            h.th.arrowDiv.onclick = function(event) {
              event = event || window.event;
              return h.onClick(axisHeaders, h, opts.colSubtotalDisplay);
            };
          }
          h.sTh = createColAttrHeaderTH(h.key, true, `pvtColLabelFiller ${classColShow} col${h.row} colcol${h.col} ${classColExpanded}`, "", void 0, colsData, {
            "data-colnode": h.node,
            "rowspan": colAttrs.length - h.col - 1
          });
          if (opts.colSubtotalDisplay.hideOnExpand) {
            replaceClass(h.sTh, classColShow, classColHide);
          }
          h[h.children[0]].tr.appendChild(h.sTh);
        }
        if ((ref4 = h.parent) != null) {
          ref4.childrenSpan += h.th.colSpan;
        }
        h.clickStatus = clickStatusExpanded;
        ah.tr.appendChild(h.th);
        h.tr = ah.tr;
        attrHeaders.push(h);
        return node.counter++;
      };
      buildRowTotalsHeader = function(tr, span, colsWidth) {
        var th;
        th = createColAttrHeaderTH([], true, "pvtTotalLabel rowTotal", "", void 0, colsWidth, {
          rowspan: span
        });
        return tr.appendChild(th);
      };
      buildRowHeaders = function(tbody, rowAxisHeaders, rowAttrHeaders, rowKeyHeaders, rowAttrs, node, clusterize, opts, start, childrenCnt) {
        var chKey, finish, k, ref3, ref4, startTime;
        startTime = Date.now();
        finish = 0;
        for (i = k = ref3 = start, ref4 = childrenCnt; (ref3 <= ref4 ? k < ref4 : k > ref4); i = ref3 <= ref4 ? ++k : --k) {
          finish = i;
          chKey = rowKeyHeaders.children[i];
          buildRowHeader(tbody, rowAxisHeaders, rowAttrHeaders, rowKeyHeaders[chKey], rowAttrs, colAttrs, node, [i === childrenCnt - 1], opts);
          if (!clusterize && (Date.now() - startTime) > 100) { //100ms check
            break;
          }
        }
        if (finish + 1 < childrenCnt) {
          return setTimeout(function() {
            return buildRowHeaders(tbody, rowAxisHeaders, rowAttrHeaders, rowKeyHeaders, rowAttrs, node, clusterize, opts, finish + 1, childrenCnt);
          }, 0);
        }
      };
      buildRowHeader = function(tbody, axisHeaders, attrHeaders, h, rowAttrs, colAttrs, node, isLastChildList, opts) {
        var ah, arrowClass, arrowOpts, chKey, colSpan, firstChild, isExpanded, k, l, ref3, ref4, ref5, th, thClass, zoomClassPart;
        for (i = k = 0, ref3 = h.children.length; (0 <= ref3 ? k < ref3 : k > ref3); i = 0 <= ref3 ? ++k : --k) {
          chKey = h.children[i];
          isLastChildList.push(i === h.children.length - 1);
          buildRowHeader(tbody, axisHeaders, attrHeaders, h[chKey], rowAttrs, colAttrs, node, isLastChildList, opts);
          isLastChildList.pop();
        }
        h.isLastChildList = isLastChildList.slice(0);
        ah = axisHeaders.ah[h.col];
        ah.attrHeaders.push(h);
        h.node = node.counter;
        h.onClick = collapseRow;
        if (h.children.length !== 0) {
          firstChild = h[h.children[0]];
        }
        colSpan = 1 + longestGroupLength(rowGroups) - h.values.length;
        if (colAttrs.length > 0 && !hideColAxisHeadersColumn) {
          colSpan += 1;
        }
        h.tr = createElement("tr", `row${h.row}`);
        if (h.children.length === 0) {
          tbody.appendChild(h.tr);
        } else {
          tbody.insertBefore(h.tr, firstChild.tr);
        }
        h.ths = [];
        if (h.children.length !== 0) {
          isExpanded = true;
          arrowOpts = {
            style: `padding-left: ${rowArrowsPadding + h.col * rowArrowsLevelPadding}px;`
          };
        } else {
          arrowOpts = {};
        }
        zoomClassPart = isExpanded != null ? classZoom : "";
        arrowClass = `pvtRowLabel ${classRowShow} row${h.row} rowcol${h.col} ${classRowExpanded} ${zoomClassPart}`;
        h.arrowTh = createRowAttrHeaderTH(h.key, void 0, arrowClass, "", true, isExpanded, h.isLastChildList, arrowOpts);
        if (arrowColumnIsNeeded()) {
          h.ths.push(h.arrowTh);
          h.tr.appendChild(h.arrowTh);
        }
        for (i = l = 0, ref4 = h.values.length; (0 <= ref4 ? l < ref4 : l > ref4); i = 0 <= ref4 ? ++l : --l) {
          thClass = `pvtRowLabel ${classRowShow} row${h.row} rowcol${h.col} ${classRowExpanded}`;
          th = createRowAttrHeaderTH(h.key, rowGroups[h.col][i], thClass, h.values[i], false, void 0, h.isLastChildList, {
            "data-rownode": h.node
          });
          if (i + 1 === h.values.length) {
            th.colSpan = colSpan;
          }
          h.ths.push(th);
          h.tr.appendChild(th);
        }
        if (h.children.length !== 0) {
          ++ah.expandedCount;
          ++ah.expandables;
          if (!opts.rowSubtotalDisplay.disableExpandCollapse && arrowColumnIsNeeded()) {
            h.arrowTh.onclick = function(event) {
              event = event || window.event;
              return h.onClick(axisHeaders, h, opts.rowSubtotalDisplay);
            };
          }
          if (!opts.rowSubtotalDisplay.displayOnTop) {
            h.sTr = createElement("tr", `row${h.row}`);
            tbody.appendChild(h.sTr);
          }
        }
        if ((ref5 = h.parent) != null) {
          ref5.childrenSpan += 1;
        }
        h.clickStatus = clickStatusExpanded;
        attrHeaders.push(h);
        return node.counter++;
      };
      getTableEventHandlers = function(value, rowKey, colKey, rowAttrs, colAttrs, opts) {
        var attr, event, eventHandlers, filters, handler, ref3, ref4;
        if (!((ref3 = opts.table) != null ? ref3.eventHandlers : void 0)) {
          return;
        }
        eventHandlers = {};
        ref4 = opts.table.eventHandlers;
        for (event in ref4) {
          if (!hasProp.call(ref4, event)) continue;
          handler = ref4[event];
          filters = {};
          for (i in colAttrs) {
            if (!hasProp.call(colAttrs, i)) continue;
            attr = colAttrs[i];
            if (colKey[i] != null) {
              filters[attr] = colKey[i];
            }
          }
          for (i in rowAttrs) {
            if (!hasProp.call(rowAttrs, i)) continue;
            attr = rowAttrs[i];
            if (rowKey[i] != null) {
              filters[attr] = rowKey[i];
            }
          }
          eventHandlers[event] = function(e) {
            return handler(e, value, filters, pivotData);
          };
        }
        return eventHandlers;
      };
      buildValues = function(scrollDiv, tbody, colAttrHeaders, rowAttrHeaders, rowAttrs, colAttrs, clusterize, opts) {
        var c, clusterizedRowsDiv;
        if (clusterize) {
          addClass(scrollDiv, "clusterize-scroll");
          addClass(tbody, "clusterize-content");
          c = new Clusterize({
            rows: [],
            scrollElem: scrollDiv,
            contentElem: tbody
          });
          clusterizedRowsDiv = createElement('div');
        }
        return setTimeout(function() {
          return fillData(scrollDiv, tbody, colAttrHeaders, rowAttrHeaders, rowAttrs, colAttrs, c, clusterizedRowsDiv, opts, 0);
        }, 0);
      };
      fillData = function(scrollDiv, tbody, colAttrHeaders, rowAttrHeaders, rowAttrs, colAttrs, c, clusterizedRowsDiv, opts, start) {
        var aggregator, ch, cls, finish, k, l, len1, rCls, ref3, ref4, ref5, rh, startTime, td, totalAggregator, tr, val;
        startTime = Date.now();
        finish = 0;
        for (i = k = ref3 = start, ref4 = rowAttrHeaders.length; (ref3 <= ref4 ? k < ref4 : k > ref4); i = ref3 <= ref4 ? ++k : --k) {
          finish = i;
          rh = rowAttrHeaders[i];
          if (rh) {
            rCls = `pvtVal row${rh.row} rowcol${rh.col} ${classRowExpanded}`;
            if (rh.children.length > 0) {
              rCls += " pvtRowSubtotal";
              rCls += opts.rowSubtotalDisplay.hideOnExpand ? ` ${classRowHide}` : `  ${classRowShow}`;
            } else {
              rCls += ` ${classRowShow}`;
            }
            tr = rh.sTr ? rh.sTr : rh.tr;
            for (l = 0, len1 = colAttrHeaders.length; l < len1; l++) {
              ch = colAttrHeaders[l];
              if (!(ch.col === colAttrs.length - 1 || (ch.children.length !== 0 && colSubtotalIsEnabled(opts.colSubtotalDisplay, ch.col)))) {
                continue;
              }
              aggregator = (ref5 = tree[rh.flatKey][ch.flatKey]) != null ? ref5 : {
                value: (function() {
                  return null;
                }),
                format: function() {
                  return "";
                }
              };
              val = aggregator.value();
              cls = ` ${rCls} col${ch.row} colcol${ch.col} ${classColExpanded}`;
              if (ch.children.length > 0) {
                cls += " pvtColSubtotal";
                cls += opts.colSubtotalDisplay.hideOnExpand ? ` ${classColHide}` : ` ${classColShow}`;
              } else {
                cls += ` ${classColShow}`;
              }
              td = createValueTD(val, rh.key, ch.key, aggregator, cls, {
                "data-value": val,
                "data-rownode": rh.node,
                "data-colnode": ch.node
              }, getTableEventHandlers(val, rh.key, ch.key, rowAttrs, colAttrs, opts));
              tr.appendChild(td);
            }
            if (!hideRowsTotalsCol) {
              // buildRowTotal
              totalAggregator = rowTotals[rh.flatKey];
              val = totalAggregator.value();
              td = createValueTD(val, rh.key, [], totalAggregator, `pvtTotal rowTotal ${rCls}`, {
                "data-value": val,
                "data-row": `row${rh.row}`,
                "data-rowcol": `col${rh.col}`,
                "data-rownode": rh.node
              }, getTableEventHandlers(val, rh.key, [], rowAttrs, colAttrs, opts));
              tr.appendChild(td);
            }
            if (c) {
              c.append([tr.outerHTML]);
              clusterizedRowsDiv.appendChild(tr);
            }
          }
          if ((Date.now() - startTime) > 100) { //100ms check
            break;
          }
        }
        return setTimeout(function() {
          if ((finish + 1) < rowAttrHeaders.length) {
            return fillData(scrollDiv, tbody, colAttrHeaders, rowAttrHeaders, rowAttrs, colAttrs, c, clusterizedRowsDiv, opts, finish + 1);
          } else if (callbacks) {
            return callbacks.finishFillData(clusterizedRowsDiv);
          }
        }, 0);
      };
      buildColTotalsHeader = function(rowHeadersColumns, colAttrs) {
        var arrowTh, colspan, th, tr;
        tr = createElement("tr");
        colspan = rowHeadersColumns + (colAttrs.length === 0 || hideColAxisHeadersColumn ? 0 : 1);
        if (colspan > 0) {
          if (arrowColumnIsNeeded()) {
            arrowTh = createRowAttrHeaderTH([], void 0, "pvtTotalLabel colTotal", "", true, void 0, []);
            tr.appendChild(arrowTh);
          }
          th = createRowAttrHeaderTH([], void 0, "pvtTotalLabel colTotal", "", false, void 0, [], {
            colspan: colspan
          });
          tr.appendChild(th);
        }
        return tr;
      };
      buildColTotals = function(tr, attrHeaders, rowAttrs, colAttrs, opts) {
        var clsNames, h, k, len1, results, td, totalAggregator, val;
        results = [];
        for (k = 0, len1 = attrHeaders.length; k < len1; k++) {
          h = attrHeaders[k];
          if (!(h.col === colAttrs.length - 1 || (h.children.length !== 0 && colSubtotalIsEnabled(opts.colSubtotalDisplay, h.col)))) {
            continue;
          }
          clsNames = `pvtVal pvtTotal colTotal ${classColExpanded} col${h.row} colcol${h.col}`;
          if (h.children.length !== 0) {
            clsNames += " pvtColSubtotal";
            clsNames += opts.colSubtotalDisplay.hideOnExpand ? ` ${classColHide}` : ` ${classColShow}`;
          } else {
            clsNames += ` ${classColShow}`;
          }
          totalAggregator = colTotals[h.flatKey];
          val = totalAggregator.value();
          td = createValueTD(val, [], h.key, totalAggregator, clsNames, {
            "data-value": val,
            "data-for": `col${h.col}`,
            "data-colnode": `${h.node}`
          }, getTableEventHandlers(val, [], h.key, rowAttrs, colAttrs, opts));
          results.push(tr.appendChild(td));
        }
        return results;
      };
      buildGrandTotal = function(tbody, tr, rowAttrs, colAttrs, opts) {
        var td, totalAggregator, val;
        totalAggregator = allTotal;
        val = totalAggregator.value();
        td = createValueTD(val, [], [], totalAggregator, "pvtGrandTotal", {
          "data-value": val
        }, getTableEventHandlers(val, [], [], rowAttrs, colAttrs, opts));
        return tr.appendChild(td);
      };
      collapseColAxisHeaders = function(axisHeaders, col, opts) {
        var ah, k, ref3, ref4, results;
        results = [];
        for (i = k = ref3 = col, ref4 = axisHeaders.ah.length - 2; (ref3 <= ref4 ? k <= ref4 : k >= ref4); i = ref3 <= ref4 ? ++k : --k) {
          if (colSubtotalIsEnabled(opts, i)) {
            ah = axisHeaders.ah[i];
            replaceClass(ah.th, classExpanded, classCollapsed);
            renderColAxisHeader(ah.th, ah.text, ah.text, false, true);
            ah.clickStatus = clickStatusCollapsed;
            results.push(ah.onClick = expandAxis);
          } else {
            results.push(void 0);
          }
        }
        return results;
      };
      collapseRowAxisHeaders = function(axisHeaders, row, opts) {
        var ah, k, l, len1, ref3, ref4, ref5, results, th;
        results = [];
        for (i = k = ref3 = row, ref4 = axisHeaders.ah.length - 2; (ref3 <= ref4 ? k <= ref4 : k >= ref4); i = ref3 <= ref4 ? ++k : --k) {
          ah = axisHeaders.ah[i];
          ref5 = ah.ths;
          for (l = 0, len1 = ref5.length; l < len1; l++) {
            th = ref5[l];
            replaceClass(th, classExpanded, classCollapsed);
          }
          renderRowAxisHeader(ah.arrowTh, "", ah.values[0], true, false);
          ah.clickStatus = clickStatusCollapsed;
          results.push(ah.onClick = expandAxis);
        }
        return results;
      };
      adjustColAxisHeader = function(axisHeaders, col, opts) {
        var ah;
        if (!hideColAxisHeadersColumn) {
          ah = axisHeaders.ah[col];
          if (ah.expandedCount === 0) {
            return collapseColAxisHeaders(axisHeaders, col, opts);
          } else if (ah.expandedCount === ah.expandables) {
            replaceClass(ah.th, classCollapsed, classExpanded);
            renderColAxisHeader(ah.th, ah.text, ah.text, true, true);
            ah.clickStatus = clickStatusExpanded;
            return ah.onClick = collapseColAxis;
          }
        }
      };
      adjustRowAxisHeader = function(axisHeaders, row, opts) {
        var ah, k, len1, ref3, th;
        ah = axisHeaders.ah[row];
        if (ah.expandedCount === 0) {
          return collapseRowAxisHeaders(axisHeaders, row, opts);
        } else if (ah.expandedCount === ah.expandables) {
          ref3 = ah.ths;
          for (k = 0, len1 = ref3.length; k < len1; k++) {
            th = ref3[k];
            replaceClass(th, classCollapsed, classExpanded);
          }
          renderRowAxisHeader(ah.arrowTh, "", ah.values[0], true, true);
          ah.clickStatus = clickStatusExpanded;
          return ah.onClick = collapseRowAxis;
        }
      };
      hideChildCol = function(ch) {
        var col, outerDiv;
        outerDiv = $(ch.th).closest('div.subtotalouterdiv');
        outerDiv.find(`tbody tr td[data-colnode=\"${ch.node}\"], th[data-colnode=\"${ch.node}\"]`).removeClass(classColShow).addClass(classColHide);
        col = outerDiv.find(`colgroup col[data-colnode=\"${ch.node}\"]`);
        if (col != null) {
          col.removeClass(classColShow);
        }
        return col != null ? col.addClass(classColHide) : void 0;
      };
      collapseHiddenColSubtotal = function(h, opts) {
        $(h.th).closest('div.subtotalouterdiv').find(`tbody tr td[data-colnode=\"${h.node}\"], th[data-colnode=\"${h.node}\"]`).removeClass(classColExpanded).addClass(classColCollapsed);
        if (h.children.length !== 0) {
          renderColAttrHeader(h.th, h.value, h.key, false, false, true);
        }
        return h.th.colSpan = 1;
      };
      collapseShowColSubtotal = function(h, opts) {
        var col, outerDiv;
        outerDiv = $(h.th).closest('div.subtotalouterdiv');
        outerDiv.find(`tbody tr td[data-colnode=\"${h.node}\"], th[data-colnode=\"${h.node}\"]`).removeClass(classColExpanded).addClass(classColCollapsed).removeClass(classColHide).addClass(classColShow);
        col = outerDiv.find(`colgroup col[data-colnode=\"${h.node}\"]`);
        if (col != null) {
          col.removeClass(classColHide);
        }
        if (col != null) {
          col.addClass(classColShow);
        }
        if (h.children.length !== 0) {
          renderColAttrHeader(h.th, h.value, h.key, false, false, true);
        }
        return h.th.colSpan = 1;
      };
      collapseChildCol = function(ch, h) {
        var chKey, k, len1, ref3;
        ref3 = ch.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          if (hasClass(ch[chKey].th, classColShow)) {
            collapseChildCol(ch[chKey], h);
          }
        }
        return hideChildCol(ch);
      };
      collapseCol = function(axisHeaders, h, opts) {
        var chKey, colSpan, k, len1, p, ref3;
        colSpan = h.th.colSpan - 1;
        ref3 = h.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          if (hasClass(h[chKey].th, classColShow)) {
            collapseChildCol(h[chKey], h);
          }
        }
        if (colSubtotalIsEnabled(opts, h.col)) {
          if (hasClass(h.th, classColHide)) {
            collapseHiddenColSubtotal(h, opts);
          } else {
            collapseShowColSubtotal(h, opts);
          }
        }
        if (!hasClass(h.th, classColHide)) {
          p = h.parent;
          while (p) {
            p.th.colSpan -= colSpan;
            p = p.parent;
          }
          if (emptyTopAttrTH != null) {
            emptyTopAttrTH.colSpan -= colSpan;
          }
        }
        h.clickStatus = clickStatusCollapsed;
        h.onClick = expandCol;
        axisHeaders.ah[h.col].expandedCount--;
        return adjustColAxisHeader(axisHeaders, h.col, opts);
      };
      showChildCol = function(ch) {
        var col, outerDiv;
        outerDiv = $(ch.th).closest('div.subtotalouterdiv');
        outerDiv.find(`tbody tr td[data-colnode=\"${ch.node}\"], th[data-colnode=\"${ch.node}\"]`).removeClass(classColHide).addClass(classColShow);
        col = outerDiv.find(`colgroup col[data-colnode=\"${ch.node}\"]`);
        if (col != null) {
          col.removeClass(classColHide);
        }
        return col != null ? col.addClass(classColShow) : void 0;
      };
      expandHideColSubtotal = function(h) {
        var col, outerDiv;
        outerDiv = $(h.th).closest('div.subtotalouterdiv');
        outerDiv.find(`tbody tr td[data-colnode=\"${h.node}\"], th[data-colnode=\"${h.node}\"]`).removeClass(`${classColCollapsed} ${classColShow}`).addClass(`${classColExpanded} ${classColHide}`);
        col = outerDiv.find(`colgroup col[data-colnode=\"${h.node}\"]`);
        if (col != null) {
          col.removeClass(classColShow);
        }
        if (col != null) {
          col.addClass(classColHide);
        }
        replaceClass(h.th, classColHide, classColShow);
        return renderColAttrHeader(h.th, h.value, h.key, false, true, true);
      };
      expandShowColSubtotal = function(h) {
        var col, outerDiv;
        outerDiv = $(h.th).closest('div.subtotalouterdiv');
        outerDiv.find(`tbody tr td[data-colnode=\"${h.node}\"], th[data-colnode=\"${h.node}\"]`).removeClass(`${classColCollapsed} ${classColHide}`).addClass(`${classColExpanded} ${classColShow}`);
        col = outerDiv.find(`colgroup col[data-colnode=\"${h.node}\"]`);
        if (col != null) {
          col.removeClass(classColHide);
        }
        if (col != null) {
          col.addClass(classColShow);
        }
        h.th.colSpan++;
        return renderColAttrHeader(h.th, h.value, h.key, false, true, true);
      };
      expandChildCol = function(ch, opts) {
        var chKey, k, len1, ref3, results;
        if (ch.children.length !== 0 && opts.hideOnExpand && ch.clickStatus === clickStatusExpanded) {
          replaceClass(ch.th, classColHide, classColShow);
        } else {
          showChildCol(ch);
        }
        if (ch.sTh && ch.clickStatus === clickStatusExpanded && opts.hideOnExpand) {
          replaceClass(ch.sTh, classColShow, classColHide);
        }
        if (ch.clickStatus === clickStatusExpanded || !colSubtotalIsEnabled(opts, ch.col)) {
          ref3 = ch.children;
          results = [];
          for (k = 0, len1 = ref3.length; k < len1; k++) {
            chKey = ref3[k];
            results.push(expandChildCol(ch[chKey], opts));
          }
          return results;
        }
      };
      expandCol = function(axisHeaders, h, opts) {
        var ch, chKey, colSpan, k, len1, p, ref3;
        if (h.clickStatus === clickStatusExpanded) {
          adjustColAxisHeader(axisHeaders, h.col, opts);
          return;
        }
        colSpan = 0;
        ref3 = h.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          ch = h[chKey];
          expandChildCol(ch, opts);
          colSpan += ch.th.colSpan;
        }
        h.th.colSpan = colSpan;
        if (colSubtotalIsEnabled(opts, h.col)) {
          if (opts.hideOnExpand) {
            expandHideColSubtotal(h);
            --colSpan;
          } else {
            expandShowColSubtotal(h);
          }
        }
        p = h.parent;
        while (p) {
          p.th.colSpan += colSpan;
          p = p.parent;
        }
        if (emptyTopAttrTH != null) {
          emptyTopAttrTH.colSpan += colSpan;
        }
        h.clickStatus = clickStatusExpanded;
        h.onClick = collapseCol;
        axisHeaders.ah[h.col].expandedCount++;
        return adjustColAxisHeader(axisHeaders, h.col, opts);
      };
      hideChildRow = function(ch, opts) {
        var cell, k, l, len1, len2, ref3, ref4, results;
        ref3 = ch.tr.querySelectorAll("th, td");
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          cell = ref3[k];
          replaceClass(cell, classRowShow, classRowHide);
        }
        if (ch.sTr) {
          ref4 = ch.sTr.querySelectorAll("th, td");
          results = [];
          for (l = 0, len2 = ref4.length; l < len2; l++) {
            cell = ref4[l];
            results.push(replaceClass(cell, classRowShow, classRowHide));
          }
          return results;
        }
      };
      collapseShowRowSubtotal = function(h, opts) {
        var cell, k, l, len1, len2, ref3, ref4, results;
        renderRowAttrHeader(h.arrowTh, "", h.key, void 0, true, false, h.isLastChildList);
        ref3 = h.tr.querySelectorAll("th, td");
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          cell = ref3[k];
          removeClass(cell, `${classRowExpanded}`);
          addClass(cell, `${classRowCollapsed}`);
        }
        if (h.sTr) {
          ref4 = h.sTr.querySelectorAll("th, td");
          results = [];
          for (l = 0, len2 = ref4.length; l < len2; l++) {
            cell = ref4[l];
            removeClass(cell, `${classRowExpanded}`);
            results.push(addClass(cell, `${classRowCollapsed}`));
          }
          return results;
        }
      };
      collapseChildRow = function(ch, h, opts) {
        var chKey, k, len1, ref3;
        ref3 = ch.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          collapseChildRow(ch[chKey], h, opts);
        }
        return hideChildRow(ch, opts);
      };
      collapseRow = function(axisHeaders, h, opts) {
        var chKey, k, len1, ref3;
        ref3 = h.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          collapseChildRow(h[chKey], h, opts);
        }
        collapseShowRowSubtotal(h, opts);
        h.clickStatus = clickStatusCollapsed;
        h.onClick = expandRow;
        axisHeaders.ah[h.col].expandedCount--;
        adjustRowAxisHeader(axisHeaders, h.col, opts);
        return callbacks.checkPadding();
      };
      showChildRow = function(ch, opts) {
        var cell, k, l, len1, len2, ref3, ref4, results;
        ref3 = ch.tr.querySelectorAll("th, td");
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          cell = ref3[k];
          replaceClass(cell, classRowHide, classRowShow);
        }
        if (ch.sTr) {
          ref4 = ch.sTr.querySelectorAll("th, td");
          results = [];
          for (l = 0, len2 = ref4.length; l < len2; l++) {
            cell = ref4[l];
            results.push(replaceClass(cell, classRowHide, classRowShow));
          }
          return results;
        }
      };
      expandShowRowSubtotal = function(h, opts) {
        var cell, k, l, len1, len2, ref3, ref4, results;
        renderRowAttrHeader(h.arrowTh, "", h.key, void 0, true, true, h.isLastChildList);
        ref3 = h.tr.querySelectorAll("th, td");
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          cell = ref3[k];
          removeClass(cell, `${classRowCollapsed} ${classRowHide}`);
          addClass(cell, `${classRowExpanded} ${classRowShow}`);
        }
        if (h.sTr) {
          ref4 = h.sTr.querySelectorAll("th, td");
          results = [];
          for (l = 0, len2 = ref4.length; l < len2; l++) {
            cell = ref4[l];
            removeClass(cell, `${classRowCollapsed} ${classRowHide}`);
            results.push(addClass(cell, `${classRowExpanded} ${classRowShow}`));
          }
          return results;
        }
      };
      expandHideRowSubtotal = function(h, opts) {
        var cell, k, l, len1, len2, len3, o, ref3, ref4, ref5, results, th;
        renderRowAttrHeader(h.arrowTh, "", h.key, void 0, true, true, h.isLastChildList);
        ref3 = h.tr.querySelectorAll("th, td");
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          cell = ref3[k];
          removeClass(cell, `${classRowCollapsed} ${classRowShow}`);
          addClass(cell, `${classRowExpanded} ${classRowHide}`);
        }
        ref4 = h.ths;
        for (l = 0, len2 = ref4.length; l < len2; l++) {
          th = ref4[l];
          removeClass(th, `${classRowCollapsed} ${classRowHide}`);
        }
        addClass(cell, `${classRowExpanded} ${classRowShow}`);
        if (h.sTr) {
          ref5 = h.sTr.querySelectorAll("th, td");
          results = [];
          for (o = 0, len3 = ref5.length; o < len3; o++) {
            cell = ref5[o];
            removeClass(cell, `${classRowCollapsed} ${classRowShow}`);
            results.push(addClass(cell, `${classRowExpanded} ${classRowHide}`));
          }
          return results;
        }
      };
      expandChildRow = function(ch, opts) {
        var chKey, k, l, len1, len2, ref3, ref4, results, th;
        if (ch.children.length !== 0 && opts.hideOnExpand && ch.clickStatus === clickStatusExpanded) {
          ref3 = ch.ths;
          for (k = 0, len1 = ref3.length; k < len1; k++) {
            th = ref3[k];
            replaceClass(th, classRowHide, classRowShow);
          }
        } else {
          showChildRow(ch, opts);
        }
        if (ch.sTh && ch.clickStatus === clickStatusExpanded && opts.hideOnExpand) {
          replaceClass(ch.sTh, classRowShow, classRowHide);
        }
        if (ch.clickStatus === clickStatusExpanded) {
          ref4 = ch.children;
          results = [];
          for (l = 0, len2 = ref4.length; l < len2; l++) {
            chKey = ref4[l];
            results.push(expandChildRow(ch[chKey], opts));
          }
          return results;
        }
      };
      expandRow = function(axisHeaders, h, opts) {
        var ch, chKey, k, len1, ref3;
        if (h.clickStatus === clickStatusExpanded) {
          adjustRowAxisHeader(axisHeaders, h.col, opts);
          return;
        }
        ref3 = h.children;
        for (k = 0, len1 = ref3.length; k < len1; k++) {
          chKey = ref3[k];
          ch = h[chKey];
          expandChildRow(ch, opts);
        }
        if (h.children.length !== 0) {
          if (opts.hideOnExpand) {
            expandHideRowSubtotal(h, opts);
          } else {
            expandShowRowSubtotal(h, opts);
          }
        }
        h.clickStatus = clickStatusExpanded;
        h.onClick = collapseRow;
        axisHeaders.ah[h.col].expandedCount++;
        adjustRowAxisHeader(axisHeaders, h.col, opts);
        return callbacks.checkPadding();
      };
      collapseColAxis = function(axisHeaders, col, attrs, opts) {
        var h, k, ref3, ref4, results;
        results = [];
        for (i = k = ref3 = attrs.length - 2, ref4 = col; k >= ref4; i = k += -1) {
          if (colSubtotalIsEnabled(opts, i)) {
            results.push((function() {
              var l, len1, ref5, results1;
              ref5 = axisHeaders.ah[i].attrHeaders;
              results1 = [];
              for (l = 0, len1 = ref5.length; l < len1; l++) {
                h = ref5[l];
                if (h.clickStatus === clickStatusExpanded && h.children.length !== 0) {
                  results1.push(axisHeaders.collapseAttrHeader(axisHeaders, h, opts));
                }
              }
              return results1;
            })());
          } else {
            results.push(void 0);
          }
        }
        return results;
      };
      collapseRowAxis = function(axisHeaders, row, attrs, opts) {
        var h, k, ref3, ref4, results;
        results = [];
        for (i = k = ref3 = axisHeaders.ah.length - 2, ref4 = row; k >= ref4; i = k += -1) {
          results.push((function() {
            var l, len1, ref5, results1;
            ref5 = axisHeaders.ah[i].attrHeaders;
            results1 = [];
            for (l = 0, len1 = ref5.length; l < len1; l++) {
              h = ref5[l];
              if (h.clickStatus === clickStatusExpanded && h.children.length !== 0) {
                results1.push(axisHeaders.collapseAttrHeader(axisHeaders, h, opts));
              }
            }
            return results1;
          })());
        }
        return results;
      };
      expandAxis = function(axisHeaders, col, attrs, opts) {
        var ah, h, k, ref3, results;
        ah = axisHeaders.ah[col];
        results = [];
        for (i = k = 0, ref3 = col; (0 <= ref3 ? k <= ref3 : k >= ref3); i = 0 <= ref3 ? ++k : --k) {
          results.push((function() {
            var l, len1, ref4, results1;
            ref4 = axisHeaders.ah[i].attrHeaders;
            results1 = [];
            for (l = 0, len1 = ref4.length; l < len1; l++) {
              h = ref4[l];
              results1.push(axisHeaders.expandAttrHeader(axisHeaders, h, opts));
            }
            return results1;
          })());
        }
        return results;
      };
      
      // when h.clickStatus is clickStatusCollapsed and h.children.length isnt 0 for i in [0..col] 
      createColGroup = function(columnData) {
        var cdata, colgroup, column, k, len1;
        colgroup = createElement("colgroup");
        for (k = 0, len1 = columnData.length; k < len1; k++) {
          cdata = columnData[k];
          column = createElement("col", null, {
            style: `width: ${cdata.width}px`,
            "data-colnode": cdata.colnode
          });
          colgroup.appendChild(column);
        }
        return colgroup;
      };
      getColumnWidth = function(isAttrColumn, colKeyValues, axisValues, isArrow) {
        if (callbacks != null) {
          return callbacks.getColumnWidth(isAttrColumn, colKeyValues, axisValues, isArrow, rowGroups.length - 1);
        } else {
          if (isArrow) {
            return 15 + 10 * (rowGroups.length - 1);
          } else {
            return 50;
          }
        }
      };
      rowHeaderColsData = function(trs, rowAttrsCnt) {
        var colCnt, colsData, columns, curColumn, first, k, l, lastShift, o, ref3, ref4, ref5, ref6, ref7, ref8, rowIndex, th, tr, value;
        if (trs.length > 0) {
          colCnt = findAxisHeadersColCount(trs[0]);
          columns = (function() {
            var k, ref3, results;
            results = [];
            for (i = k = 0, ref3 = colCnt; (0 <= ref3 ? k < ref3 : k > ref3); i = 0 <= ref3 ? ++k : --k) {
              results.push([]);
            }
            return results;
          })();
          colsData = (function() {
            var k, ref3, results;
            results = [];
            for (i = k = 0, ref3 = colCnt; (0 <= ref3 ? k < ref3 : k > ref3); i = 0 <= ref3 ? ++k : --k) {
              results.push({
                width: 0
              });
            }
            return results;
          })();
          first = 0;
          if (arrowColumnIsNeeded()) {
            colsData[0].width = getColumnWidth(false, null, null, true);
            first = 1;
          }
          lastShift = 0;
          if (colAttrs.length > 0 && !hideColAxisHeadersColumn) {
            colsData[colCnt - 1].width = getColumnWidth(false, null, [], false);
            lastShift = 1;
          }
          for (rowIndex = k = ref3 = trs.length - rowAttrsCnt, ref4 = trs.length; (ref3 <= ref4 ? k < ref4 : k > ref4); rowIndex = ref3 <= ref4 ? ++k : --k) {
            tr = trs[rowIndex];
            curColumn = first;
            for (i = l = ref5 = first, ref6 = tr.cells.length - lastShift; (ref5 <= ref6 ? l < ref6 : l > ref6); i = ref5 <= ref6 ? ++l : --l) {
              th = tr.cells[i];
              if (callbacks != null) {
                value = callbacks.getHeaderCellValue(th);
              } else {
                value = th.textContent;
              }
              columns[curColumn].push(value);
              curColumn += th.colSpan;
            }
          }
          for (i = o = ref7 = first, ref8 = colCnt - lastShift; (ref7 <= ref8 ? o < ref8 : o > ref8); i = ref7 <= ref8 ? ++o : --o) {
            colsData[i].width = getColumnWidth(false, null, columns[i], false);
          }
          return colsData;
        } else {
          return [getColumnWidth(true, [], null, false)];
        }
      };
      findAxisHeadersColCount = function(tr) {
        var colCnt, k, ref3, th;
        colCnt = 0;
        for (i = k = 0, ref3 = tr.cells.length; (0 <= ref3 ? k < ref3 : k > ref3); i = 0 <= ref3 ? ++k : --k) {
          th = tr.cells[i];
          colCnt += th.colSpan;
        }
        return colCnt;
      };
      main = function(rowAttrs, rowKeys, colAttrs, colKeys, clusterize) {
        var bodyDiv, bodyTable, chKey, childrenCnt, colAttrHeaders, colAxisHeaders, colKeyHeaders, colsData, colspan, headerDiv, headerTable, k, len1, node, outerDiv, overallSpan, ref3, rowAttrHeaders, rowAttrHeadersCount, rowAxisHeaders, rowKeyHeaders, scrollDiv, tbody, thead, tr, trs;
        if (callbacks) {
          callbacks.startFillData();
        }
        rowAttrHeaders = [];
        colAttrHeaders = [];
        if (colAttrs.length !== 0 && colKeys.length !== 0) {
          colKeyHeaders = processColKeys(colAttrs, colKeys);
        }
        if (rowAttrs.length !== 0 && rowKeys.length !== 0) {
          rowKeyHeaders = processRowKeys(rowAttrs, rowKeys, "pvtRowLabel", rowSplitPositions);
        }
        outerDiv = createElement("div", "subtotalouterdiv");
        headerDiv = createElement("div", "headerdiv");
        headerTable = createElement("table", "headertable pvtTable table");
        thead = createElement("thead");
        outerDiv.appendChild(headerDiv);
        headerDiv.appendChild(headerTable);
        headerTable.appendChild(thead);
        [colAxisHeaders, rowAxisHeaders, trs] = buildAxisHeaders(thead, rowAttrs, colAttrs, opts);
        colsData = rowHeaderColsData(trs, rowAxisHeaders.ah.length);
        if (colAttrs.length !== 0) {
          overallSpan = 0;
          if (colKeyHeaders != null) {
            node = {
              counter: 0
            };
            ref3 = colKeyHeaders.children;
            for (k = 0, len1 = ref3.length; k < len1; k++) {
              chKey = ref3[k];
              buildColHeader(callbacks, colAxisHeaders, colAttrHeaders, colKeyHeaders[chKey], rowAttrs, colAttrs, node, opts, colsData);
              overallSpan += colKeyHeaders[chKey].th.colSpan;
            }
          }
          if (!hideRowsTotalsCol) {
            buildRowTotalsHeader(colAxisHeaders.ah[0].tr, colAttrs.length, colsData);
          }
          rowAttrHeadersCount = rowGroups.length;
          if (rowAttrHeadersCount > colAttrs.length) {
            colspan = overallSpan + (hideRowsTotalsCol ? 0 : 1);
            emptyTopAttrTH = createElement("th", "pvtEmptyHeader", {
              colspan: colspan,
              rowspan: rowAttrHeadersCount - colAttrs.length
            });
            rowAxisHeaders.ah[0].tr.appendChild(emptyTopAttrTH);
          }
        }
        bodyDiv = createElement("div", "bodydiv");
        scrollDiv = createElement("div", "scrolldiv");
        scrollDiv.onscroll = function() {
          var sLeft;
          sLeft = scrollDiv.scrollLeft;
          headerDiv.scrollLeft = sLeft;
          //need for right border for the sticky columns
          if (sLeft > 0) {
            addClass(headerTable, "scrolled-left");
            return addClass(bodyTable, "scrolled-left");
          } else {
            removeClass(headerTable, "scrolled-left");
            return removeClass(bodyTable, "scrolled-left");
          }
        };
        bodyTable = createElement("table", "bodytable pvtTable table");
        tbody = createElement("tbody");
        outerDiv.appendChild(bodyDiv);
        bodyDiv.appendChild(scrollDiv);
        scrollDiv.appendChild(bodyTable);
        bodyTable.appendChild(tbody);
        if (rowAttrs.length !== 0) {
          if (!hideRowsTotalsCol) {
            if (colAttrs.length === 0) {
              buildRowTotalsHeader(rowAxisHeaders.ah[0].tr, rowGroups.length, colsData);
            }
          }
          if (rowKeyHeaders != null) {
            node = {
              counter: 0
            };
            childrenCnt = rowKeyHeaders.children.length;
            if (clusterize) {
              buildRowHeaders(tbody, rowAxisHeaders, rowAttrHeaders, rowKeyHeaders, rowAttrs, node, clusterize, opts, 0, childrenCnt);
            } else {
              setTimeout(function() {
                return buildRowHeaders(tbody, rowAxisHeaders, rowAttrHeaders, rowKeyHeaders, rowAttrs, node, clusterize, opts, 0, childrenCnt);
              }, 0);
            }
          }
        }
        buildValues(scrollDiv, tbody, colAttrHeaders, rowAttrHeaders, rowAttrs, colAttrs, clusterize, opts);
        if (!hideColsTotalRow) {
          tr = buildColTotalsHeader(longestGroupLength(rowGroups), colAttrs);
          if (colAttrs.length > 0) {
            buildColTotals(tr, colAttrHeaders, rowAttrs, colAttrs, opts);
          }
          if (!hideRowsTotalsCol) {
            buildGrandTotal(tbody, tr, rowAttrs, colAttrs, opts);
          }
          tbody.appendChild(tr);
        }
        collapseColAxis(colAxisHeaders, opts.colSubtotalDisplay.collapseAt, colAttrs, opts.colSubtotalDisplay);
        collapseRowAxis(rowAxisHeaders, opts.rowSubtotalDisplay.collapseAt, rowAttrs, opts.rowSubtotalDisplay);
        headerTable.style.display = "";
        bodyTable.style.display = "";
        headerTable.insertBefore(createColGroup(colsData), headerTable.firstChild);
        bodyTable.insertBefore(createColGroup(colsData), bodyTable.firstChild);
        outerDiv.setAttribute("data-numrows", rowKeys.length);
        outerDiv.setAttribute("data-numcols", colKeys.length);
        return outerDiv;
      };
      return main(rowAttrs, rowKeys, colAttrs, colKeys, clusterize);
    };
    $.pivotUtilities.subtotal_renderers = {
      "TABLE": function(pvtData, opts, clusterize) {
        return SubtotalRenderer(pvtData, opts, clusterize);
      },
      "TABLE_BARCHART": function(pvtData, opts) {
        return $(SubtotalRenderer(pvtData, opts)).barchart();
      },
      "TABLE_HEATMAP": function(pvtData, opts) {
        return $(SubtotalRenderer(pvtData, opts)).heatmap("heatmap", opts);
      },
      "TABLE_ROW_HEATMAP": function(pvtData, opts) {
        return $(SubtotalRenderer(pvtData, opts)).heatmap("rowheatmap", opts);
      },
      "TABLE_COL_HEATMAP": function(pvtData, opts) {
        return $(SubtotalRenderer(pvtData, opts)).heatmap("colheatmap", opts);
      }
    };
    
    // Aggregators

    usFmtPct = $.pivotUtilities.numberFormat({
      digitsAfterDecimal: 1,
      scaler: 100,
      suffix: "%"
    });
    aggregatorTemplates = $.pivotUtilities.aggregatorTemplates;
    subtotalAggregatorTemplates = {
      fractionOf: function(wrapped, type = "row", formatter = usFmtPct) {
        return function(...x) {
          return function(data, rowKey, colKey) {
            if (typeof rowKey === "undefined") {
              rowKey = [];
            }
            if (typeof colKey === "undefined") {
              colKey = [];
            }
            return {
              selector: {
                row: [rowKey.slice(0, -1), []],
                col: [[], colKey.slice(0, -1)]
              }[type],
              inner: wrapped(...x)(data, rowKey, colKey),
              push: function(record) {
                return this.inner.push(record);
              },
              format: formatter,
              value: function() {
                return this.inner.value() / data.getAggregator(...this.selector).inner.value();
              },
              numInputs: wrapped(...x)().numInputs
            };
          };
        };
      }
    };
    $.pivotUtilities.subtotalAggregatorTemplates = subtotalAggregatorTemplates;
    return $.pivotUtilities.subtotal_aggregators = (function(tpl, sTpl) {
      return {
        "Sum As Fraction Of Parent Row": sTpl.fractionOf(tpl.sum(), "row", usFmtPct),
        "Sum As Fraction Of Parent Column": sTpl.fractionOf(tpl.sum(), "col", usFmtPct),
        "Count As Fraction Of Parent Row": sTpl.fractionOf(tpl.count(), "row", usFmtPct),
        "Count As Fraction Of Parent Column": sTpl.fractionOf(tpl.count(), "col", usFmtPct)
      };
    })(aggregatorTemplates, subtotalAggregatorTemplates);
  });

}).call(this);

//# sourceMappingURL=subtotal.js.map
