package lsfusion.gwt.client.form.property;

import lsfusion.gwt.client.base.jsni.NativeHashMap;
import lsfusion.gwt.client.form.object.GGroupObjectValue;
import lsfusion.gwt.client.form.object.table.controller.GPropertyController;

import static lsfusion.gwt.client.GFormChanges.GPropertyReadType.*;

public class GExtraPropReader extends GExtraPropertyReader {

    private int readerType;

    public GExtraPropReader() {
    }

    public GExtraPropReader(int readerID, int groupObjectID, int readerType) {
        super(readerID, groupObjectID, getPrefix(readerType));
        this.readerType = readerType;
    }

    public void update(GPropertyController controller, NativeHashMap<GGroupObjectValue, PValue> values) {
        if(readerType == CELL_FONT) {
            controller.updateCellFontValues(this, values);
        } else if (readerType == COMMENT) {
            controller.updatePropertyComments(this, values);
        } else if (readerType == COMMENTELEMENTCLASS) {
            controller.updateCellCommentElementClasses(this, values);
        } else if (readerType == PLACEHOLDER) {
            controller.updatePlaceholderValues(this, values);
        } else if (readerType == PATTERN) {
            controller.updatePatternValues(this, values);
        } else if (readerType == REGEXP) {
            controller.updateRegexpValues(this, values);
        } else if (readerType == REGEXPMESSAGE) {
            controller.updateRegexpMessageValues(this, values);
        } else if (readerType == TOOLTIP) {
            controller.updateTooltipValues(this, values);
        } else if (readerType == VALUETOOLTIP) {
            controller.updateValueTooltipValues(this, values);
        } else if (readerType == PROPERTY_CUSTOM_OPTIONS) {
            controller.updatePropertyCustomOptionsValues(this, values);
        } else if (readerType == CHANGEKEY) {
            controller.updateChangeKeyValues(this, values);
        } else if (readerType == CHANGEMOUSE) {
            controller.updateChangeMouseValues(this, values);
        } else if(readerType == CAPTIONELEMENTCLASS) {
            controller.updateCellCaptionElementClasses(this, values);
        } else if(readerType == FOOTERELEMENTCLASS) {
            controller.updateCellFooterElementClasses(this, values);
        }
    }

    private static String getPrefix(int readerType) {
        if (readerType == CELL_FONT) {
            return "CELL_FONT";
        } else if (readerType == COMMENT) {
            return "COMMENT";
        } else if (readerType == COMMENTELEMENTCLASS) {
            return "COMMENTELEMENTCLASS";
        } else if (readerType == PLACEHOLDER) {
            return "PLACEHOLDER";
        } else if (readerType == PATTERN) {
            return "PATTERN";
        } else if (readerType == REGEXP) {
            return "REGEXP";
        } else if (readerType == REGEXPMESSAGE) {
            return "REGEXPMESSAGE";
        } else if (readerType == TOOLTIP) {
            return "TOOLTIP";
        } else if (readerType == VALUETOOLTIP) {
            return "VALUETOOLTIP";
        } else if (readerType == PROPERTY_CUSTOM_OPTIONS) {
            return "PROPERTY_CUSTOM_OPTIONS";
        } else if (readerType == CHANGEKEY) {
            return "CHANGEKEY";
        } else if (readerType == CHANGEMOUSE) {
            return "CHANGEMOUSE";
        } else if (readerType == CAPTIONELEMENTCLASS) {
            return "CAPTIONELEMENTCLASS";
        } else if (readerType == FOOTERELEMENTCLASS) {
            return "FOOTERELEMENTCLASS";
        }
        return null;
    }
}
