package lsfusion.server.data.expr.formula.conversion;

import lsfusion.server.data.query.exec.MStaticExecuteEnvironment;
import lsfusion.server.data.sql.syntax.SQLSyntax;
import lsfusion.server.logics.classes.data.DataClass;

public class CompoundConversionSource implements ConversionSource {

    private final ConversionSource[] conversionSources;

    public CompoundConversionSource(ConversionSource... conversionSources) {
        this.conversionSources = conversionSources;
    }

    @Override
    public String getSource(DataClass type1, DataClass type2, String src1, String src2, SQLSyntax syntax, MStaticExecuteEnvironment env, boolean isToString) {
        String result = null;
        for (ConversionSource conversionSource : conversionSources) {
            result = conversionSource.getSource(type1, type2, src1, src2, syntax, env, isToString);
            if (result != null) {
                break;
            }
        }
        return result;
    }
}
