###########################################################################
#
#                         INFORMIX SOFTWARE, INC.
#
#                            PROPRIETARY DATA
#
#      THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF
#      INFORMIX SOFTWARE, INC.  THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
#      CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR
#      DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT
#      SIGNED BY AN OFFICER OF INFORMIX SOFTWARE, INC.
#
#      THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
#      SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE.
#      UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
#
#
#  Title:         prep2java.sh
#
#	Netscape currently has a bug that prevents it from properly
#	reading PropertyResourceBundle files (.properties files).
#	So, this script converts all the .properties files that 
#	bldErrMsgBundle creates into .java files (ListResourceBundles).
#	When netscape fixes the bug, we can remove this script and
#	the NETSCAPEBUG target in the makefile.
#
#  Description:    
#               
###########################################################################

# If an extension is provided, use only .properties files that
# have that extension. For example, 'zh_CN' would only process
# *_zh_CN.properties files
if test $# -eq 1 ; then
   extn=$1
   list=`ls *${extn}.properties`
else
   extn=""
# Workaround/kludge: A bug in the Java 1.2 plug-in or class loader
# causes secure servers to look for certain files repeatedly, causing
# various problems. For xopen.class, we provide other variations of the
# file to avoid such problems. With Java 1.3 plug-in, this problem
# may go away. See also /vobs/jdbc/makefile. 
   list=`ls *.properties | grep -v _`  # Weed out the localized ones
fi

echo "Processing ${extn} .properties files ..."

for f in `echo $list`
do
   # echo "Processing \"$f\""
   base=`basename $f .properties`
   jfile="${base}.java"

   echo "package com.informix.msg;" > $jfile
   echo "public class ${base} extends java.util.ListResourceBundle" >> $jfile
   echo "{" >> $jfile
   echo "   public Object[][] getContents()" >> $jfile
   echo "   {" >> $jfile
   echo "      return contents;" >> $jfile
   echo "   }" >> $jfile
   echo "" >> $jfile
   echo "   static final Object[][] contents = {" >> $jfile

   awk 'BEGIN {FS=" "} {if ($1 != "#" && length($0) > 0) \
              { printf "      {\"%s\", \"", $1; \
                if (NF >= 4)
                   {printf "%s ", $3;  \
                   for (i=4;i<NF;i++) {printf "%s ", $i;}; 
                    printf "%s\"},\n", $NF; } \
                else {printf "%s\"},\n", $3;} \
                }}' $f >> $jfile

   echo "" >> $jfile
   echo "   };" >> $jfile
   echo "}" >> $jfile
done
