/*
 * Decompiled with CFR 0.152.
 */
package mycompany.utils.crypto;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import lsfusion.base.file.RawFileData;
import lsfusion.server.data.sql.exception.SQLHandledException;
import lsfusion.server.data.value.DataObject;
import lsfusion.server.language.ScriptingLogicsModule;
import lsfusion.server.logics.action.controller.context.ExecutionContext;
import lsfusion.server.logics.classes.ValueClass;
import lsfusion.server.logics.property.classes.ClassPropertyInterface;
import lsfusion.server.physics.dev.integration.internal.to.InternalAction;

public class CipherRSAOAEPMGF1Action
extends InternalAction {
    public CipherRSAOAEPMGF1Action(ScriptingLogicsModule LM, ValueClass ... classes) {
        super(LM, classes);
    }

    protected void executeInternal(ExecutionContext<ClassPropertyInterface> context) throws SQLException, SQLHandledException {
        RawFileData raw = (RawFileData)this.getParam(0, context);
        String mdName = (String)this.getParam(1, context);
        String certificatePem = (String)this.getParam(2, context);
        try {
            PublicKey publicKey = CipherRSAOAEPMGF1Action.loadPublicKeyFromBase64(certificatePem);
            OAEPParameterSpec oaep256 = new OAEPParameterSpec(mdName, "MGF1", new MGF1ParameterSpec(mdName), PSource.PSpecified.DEFAULT);
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
            cipher.init(1, (Key)publicKey, oaep256);
            byte[] inputBytes = raw != null ? raw.getBytes() : new byte[]{};
            byte[] result = cipher.doFinal(inputBytes);
            this.findProperty("cipherResult[]").change(new RawFileData(result), context, new DataObject[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cipher error", e);
        }
    }

    private static PublicKey loadPublicKeyFromBase64(String certificatePem) throws CertificateException {
        ByteArrayInputStream input = new ByteArrayInputStream(certificatePem.getBytes(StandardCharsets.UTF_8));
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)factory.generateCertificate(input);
        return certificate.getPublicKey();
    }
}

