/*
 * Decompiled with CFR 0.152.
 */
package mycompany.utils.crypto;

import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lsfusion.base.file.RawFileData;
import lsfusion.server.data.sql.exception.SQLHandledException;
import lsfusion.server.data.value.DataObject;
import lsfusion.server.language.ScriptingLogicsModule;
import lsfusion.server.logics.action.controller.context.ExecutionContext;
import lsfusion.server.logics.classes.ValueClass;
import lsfusion.server.logics.property.classes.ClassPropertyInterface;
import lsfusion.server.physics.dev.integration.internal.to.InternalAction;

public class GenerateAESKeyIVAction
extends InternalAction {
    public GenerateAESKeyIVAction(ScriptingLogicsModule LM, ValueClass ... classes) {
        super(LM, classes);
    }

    protected void executeInternal(ExecutionContext<ClassPropertyInterface> context) throws SQLException, SQLHandledException {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey key = keyGen.generateKey();
            byte[] keyBytes = key.getEncoded();
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            String ivB64 = Base64.getEncoder().encodeToString(iv);
            this.findProperty("generatedAESKey[]").change(new RawFileData(keyBytes), context, new DataObject[0]);
            this.findProperty("generatedIV[]").change(ivB64, context, new DataObject[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Generate AES key/iv error", e);
        }
    }
}

